#include <iostream>
#include <vector>


using namespace std;

typedef long double ld;
typedef long long ll;


struct segtree {
    ll n;
    vector<ll> t;
    segtree() {}
    segtree(vector<ll>& in) {
        n = in.size();
        t.resize(4 * n);
        build(0, 0, n - 1, in);
    }
    void build(ll v, ll tl, ll tr, vector<ll>& in) {
        if (tl == tr) {
            t[v] = in[tl];
            return;
        }
        ll tm = (tl + tr) / 2;
        build(2 * v + 1, tl, tm, in);
        build(2 * v + 2, tm + 1, tr, in);
        t[v] = t[2 * v + 1] + t[2 * v + 2];
    }
    ll get_seg(ll v, ll tl, ll tr, ll l, ll r) {
        if (l <= tl && tr <= r) {
            return t[v];
        }
        if (tr < l || r < tl) {
            return 0;
        }
        ll tm = (tl + tr) / 2;
        return get_seg(2 * v + 1, tl, tm, l, r) + get_seg(2 * v + 2, tm + 1, tr, l, r);
    }

    ll get(ll l, ll r) {
        return get_seg(0, 0, n - 1, l, r);
    }
};

const ll INF = 1e9;

void solve() {
    ll x, y; cin >> x >> y;
    ll r = y - x;
    if (r == 0) {
        cout << 0 << '\n';
        return;
    }
    ll ans = 1;
    for (ll d = 1; d * d <= r && d <= x; d++) {
        if (r % d == 0) {
            ans = max(ans, d);
            if (r / d <= x) {
                ans = max(ans, r / d);
            }
        }
    }
    cout << x - ans << '\n';
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    ll tst; cin >> tst;
    while (tst--) {
        solve();
    }
}

